varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform sampler2D 	flow;

uniform float		alpha;

float			lum;

float wnear = 4.0;
float wfar = 50000.0;

vec4 RGBMEncode( vec3 color ) {
  vec4 rgbm;
  color *= 1.0 / 6.0;
  rgbm.a = clamp( max( max( color.r, color.g ), max( color.b, 1e-6 ) ),0.0,1.0 );
  rgbm.a = ceil( rgbm.a * 255.0 ) / 255.0;
  rgbm.rgb = color / rgbm.a;
  return rgbm;
}

void main()
{
	vec2 D=texture2D(flow, texcoord).rg;
	
	vec2 newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	D=texture2D(flow, newCoords).rg;
	newCoords=texcoord-D;
	
	vec4 color=texture2D(tex, /*texcoord*/newCoords);
	
	gl_FragColor=RGBMEncode(color.rgb);
}
